package com.hero.objects.characteristics;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.Adder;
import com.hero.objects.GenericObject;
import com.hero.objects.powers.Automaton;
import com.hero.util.Constants;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Comliness extends Characteristic {

    private static String xmlID = "COM";

    public Comliness(Element root) {
        super(root, Comliness.xmlID);
    }

    @Override
    public int getMinimumLevel() {
        return minimumLevel;
    }

    @Override
    public int getType() {
        return Constants.COM;
    }

    @Override
    public double getTotalCost() {
        enhancerApplied = null;
        double total = getBaseCost();
        if (getLevelValue() != 0) {
            if (isPower() && getLevels() < 0) {
                double bd = Math.abs(getLevels()) / getLevelValue()
                        * getLevelCost();
                total += bd;
            } else if (getLevels() < 0
                    && Math.abs(getLevels()) > getBaseValue()) {
                // negative part...
                double bd = -1 * getBaseValue() / getLevelValue()
                        * getLevelCost();
                total += bd;
                // negative COM costs points...
                bd = (Math.abs(getLevels()) - getBaseValue()) / getLevelValue()
                        * getLevelCost();
                total += bd;
                if (HeroDesigner.getActiveHero().isNCMSelected()
                        && HeroDesigner.getActiveTemplate()
                                .getNcmCostMultiplier() > 0 && !isPower()
                        && (getLevels() > 0 || getTrueBase() > getNCMLevel())) {
                    if (getNCMCharValue() > getNCMLevel()) {
                        double expensiveLevels = getNCMCharValue()
                                - getNCMLevel();
                        if (expensiveLevels > getLevels()
                                && getTrueBase() < getNCMLevel()) {
                            expensiveLevels = getLevels();
                        }
                        double adjustment = expensiveLevels / getLevelValue() * getLevelCost()
                                * (HeroDesigner.getActiveTemplate()
                                        .getNcmCostMultiplier() - 1);
                        total += adjustment;
                    }
                }
            } else {
                double bd = getLevels() / getLevelValue() * getLevelCost();
                total += bd;
                if (HeroDesigner.getActiveHero().isNCMSelected()
                        && HeroDesigner.getActiveTemplate()
                                .getNcmCostMultiplier() > 0 && !isPower()
                        && (getLevels() > 0 || getTrueBase() > getNCMLevel())) {
                    if (getNCMCharValue() > getNCMLevel()) {
                        double expensiveLevels = getNCMCharValue()
                                - getNCMLevel();
                        if (expensiveLevels > getLevels()
                                && getTrueBase() < getNCMLevel()) {
                            expensiveLevels = getLevels();
                        }
                        double adjustment = expensiveLevels / getLevelValue() * getLevelCost()
                                * (HeroDesigner.getActiveTemplate()
                                        .getNcmCostMultiplier() - 1);
                        total += adjustment;
                    }
                }
            }
        }
        for (Adder ad : getAssignedAdders()) {
            if (ad.getRealCost() > 0) {
                total += ad.getRealCost();
            }
        }
        if (total < getMinimumCost() && isMinSet()) {
            total = getMinimumCost();
        } else if (total > getMaxCost() && isMaxSet()) {
            total = getMaxCost();
        }
        for (Adder ad : getAssignedAdders()) {
            if (ad.getRealCost() < 0) {
                total += ad.getRealCost();
            }
        }
        if (getTypes().contains("DEFENSE")
                && HeroDesigner.getActiveHero() != null) {
            if (GenericObject.findObjectByID(HeroDesigner.getActiveHero().getPowers(),
                    "AUTOMATON") != null) {
                Automaton auto = (Automaton) GenericObject.findObjectByID(HeroDesigner
                        .getActiveHero().getPowers(), "AUTOMATON");
                if (auto.getSelectedOption().getXMLID().toUpperCase()
                        .startsWith("NOSTUN")) {
                    total = total * auto.getDefenseCostMultiplier();
                }
            }
        }
        return total;
    }
}